import argparse, pandas as pd, numpy as np

def verdict(row):
    ok_cov = row['splus_cov_pct'] > 0.0 and 0.2 <= row['splus_cov_pct'] <= 5.0
    ok_phi = -1.15 <= row['s_phi'] <= -0.85
    ok_E   = -2.20 <= row['s_grad'] <= -1.80
    ok_a   = row['alpha_best_r2'] >= 0.90
    return "PASS" if (ok_cov and ok_phi and ok_E and ok_a) else "FAIL"

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--summary", required=True)
    args = ap.parse_args()
    df = pd.read_csv(args.summary)
    cols = ["gauge","L","b","kappa","f","seed","splus_cov_pct","s_phi","r2_phi","s_grad","r2_grad","alpha_best_lambda","alpha_best_r2"]
    cols = [c for c in cols if c in df.columns]
    df = df[cols].copy()
    df['verdict'] = df.apply(verdict, axis=1)
    with pd.option_context('display.max_rows', None, 'display.max_columns', None):
        print(df.to_string(index=False))

if __name__ == "__main__":
    main()
